% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tessdata.R
\name{tesseract_download}
\alias{tesseract_download}
\alias{tessdata}
\title{Tesseract Training Data}
\usage{
tesseract_download(lang, datapath = NULL, progress = interactive())
}
\arguments{
\item{lang}{three letter code for language, see \href{https://github.com/tesseract-ocr/tessdata}{tessdata} repository.}

\item{datapath}{destination directory where to download store the file}

\item{progress}{print progress while downloading}
}
\description{
Helper function to download training data from the official
\href{https://github.com/tesseract-ocr/tesseract/wiki/Data-Files}{tessdata} repository. Only use this function on
Windows and OS-X. On Linux, training data can be installed directly with
\href{https://apps.fedoraproject.org/packages/tesseract}{yum} or
\href{https://packages.debian.org/search?suite=stable&section=all&arch=any&searchon=names&keywords=tesseract-ocr-}{apt-get}.
}
\details{
Tesseract uses training data to perform OCR. Most systems default to English
training data. To improve OCR performance for other languages you can to install the
training data from your distribution. For example to install the spanish training data:
\itemize{
\item \href{https://packages.debian.org/testing/tesseract-ocr-spa}{tesseract-ocr-spa} (Debian, Ubuntu)
\item \href{https://apps.fedoraproject.org/packages/tesseract-langpack-spa}{tesseract-langpack-spa} (Fedora, EPEL)
}

On Windows and MacOS you can install languages using the \link{tesseract_download} function
which downloads training data directly from \href{https://github.com/tesseract-ocr/tessdata}{github}
and stores it in a the path on disk given by the \code{TESSDATA_PREFIX} variable.
}
\examples{
\donttest{
if(is.na(match("fra", tesseract_info()$available)))
  tesseract_download("fra")
french <- tesseract("fra")
text <- ocr("https://jeroen.github.io/images/french_text.png", engine = french)
cat(text)
}
}
\references{
\href{https://github.com/tesseract-ocr/tesseract/wiki/Data-Files}{tesseract wiki: training data}
}
\seealso{
Other tesseract: \code{\link{ocr}}, \code{\link{tesseract}}
}
\concept{tesseract}
