% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_default_stats_formats_labels.R
\name{labels_use_control}
\alias{labels_use_control}
\title{Update Labels According to Control Specifications}
\usage{
labels_use_control(labels_default, control, labels_custom = NULL)
}
\arguments{
\item{labels_default}{(named \code{vector} of \code{character})\cr a named vector of statistic labels to modify
according to the control specifications. Labels that are explicitly defined in \code{labels_custom} will
not be affected.}

\item{control}{(named \code{list})\cr list of control parameters to apply to adjust default labels.}

\item{labels_custom}{(named \code{vector} of \code{character})\cr named vector of labels that are customized by
the user and should not be affected by \code{control}.}
}
\value{
A named character vector of labels with control specifications applied to relevant labels.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Given a list of statistic labels and and a list of control parameters, updates labels with a relevant
control specification. For example, if control has element \code{conf_level} set to \code{0.9}, the default
label for statistic \code{mean_ci} will be updated to \code{"Mean 90\% CI"}. Any labels that are supplied
via \code{labels_custom} will not be updated regardless of \code{control}.
}
\examples{
control <- list(conf_level = 0.80, quantiles = c(0.1, 0.83), test_mean = 0.57)
get_labels_from_stats(c("mean_ci", "quantiles", "mean_pval")) \%>\%
  labels_use_control(control = control)

}
