% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_functions.R
\name{format_count_fraction_lt10}
\alias{format_count_fraction_lt10}
\title{Formatting Count and Fraction with Special Case for Count < 10}
\usage{
format_count_fraction_lt10(x, ...)
}
\arguments{
\item{x}{(\code{integer})\cr vector of length 2, count and fraction.}

\item{...}{required for \code{rtables} interface.}
}
\value{
A string in the format \verb{count (fraction \%)}. If \code{count} is less than 10, only \code{count} is printed.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Formats a count together with fraction with special consideration when count is less than 10.
}
\examples{
format_count_fraction_lt10(x = c(275, 0.9673))
format_count_fraction_lt10(x = c(2, 0.6667))
format_count_fraction_lt10(x = c(9, 1))

}
\seealso{
Other formatting functions: 
\code{\link{extreme_format}},
\code{\link{format_auto}()},
\code{\link{format_count_fraction_fixed_dp}()},
\code{\link{format_count_fraction}()},
\code{\link{format_extreme_values_ci}()},
\code{\link{format_extreme_values}()},
\code{\link{format_fraction_fixed_dp}()},
\code{\link{format_fraction_threshold}()},
\code{\link{format_fraction}()},
\code{\link{format_sigfig}()},
\code{\link{format_xx}()},
\code{\link{formatting_functions}}
}
\concept{formatting functions}
