% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_incidence_rate.R
\name{control_incidence_rate}
\alias{control_incidence_rate}
\title{Control function for incidence rate}
\usage{
control_incidence_rate(
  conf_level = 0.95,
  conf_type = c("normal", "normal_log", "exact", "byar"),
  input_time_unit = c("year", "day", "week", "month"),
  num_pt_year = 100,
  time_unit_input = lifecycle::deprecated(),
  time_unit_output = lifecycle::deprecated()
)
}
\arguments{
\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{conf_type}{(\code{string})\cr \code{normal} (default), \code{normal_log}, \code{exact}, or \code{byar}
for confidence interval type.}

\item{input_time_unit}{(\code{string})\cr \code{day}, \code{week}, \code{month}, or \code{year} (default)
indicating time unit for data input.}

\item{num_pt_year}{(\code{numeric})\cr number of patient-years to use when calculating adverse event rates.}

\item{time_unit_input}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use the \code{input_time_unit} argument instead.}

\item{time_unit_output}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use the \code{num_pt_year} argument instead.}
}
\value{
A list of components with the same names as the arguments.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This is an auxiliary function for controlling arguments for the incidence rate, used
internally to specify details in \code{s_incidence_rate()}.
}
\examples{
control_incidence_rate(0.9, "exact", "month", 100)

}
\seealso{
\link{incidence_rate}
}
