% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaplan_meier_plot.R
\name{g_km}
\alias{g_km}
\title{Kaplan-Meier Plot}
\usage{
g_km(
  df,
  variables,
  control_surv = control_surv_timepoint(),
  col = NULL,
  lty = NULL,
  lwd = 0.5,
  censor_show = TRUE,
  pch = 3,
  size = 2,
  max_time = NULL,
  xticks = NULL,
  xlab = "Days",
  yval = c("Survival", "Failure"),
  ylab = paste(yval, "Probability"),
  ylim = NULL,
  title = NULL,
  footnotes = NULL,
  draw = TRUE,
  newpage = TRUE,
  gp = NULL,
  vp = NULL,
  name = NULL,
  font_size = 12,
  ci_ribbon = FALSE,
  ggtheme = nestcolor::theme_nest(),
  annot_at_risk = TRUE,
  annot_surv_med = TRUE,
  annot_coxph = FALSE,
  annot_stats = NULL,
  annot_stats_vlines = FALSE,
  control_coxph_pw = control_coxph(),
  position_coxph = c(-0.03, -0.02),
  position_surv_med = c(0.95, 0.9),
  width_annots = list(surv_med = grid::unit(0.3, "npc"), coxph = grid::unit(0.4, "npc"))
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{variables}{(named \code{list})\cr variable names. Details are:
\itemize{
\item \code{tte} (\code{numeric})\cr variable indicating time-to-event duration values.
\item \code{is_event} (\code{logical})\cr event variable. \code{TRUE} if event, \code{FALSE} if time to event is censored.
\item \code{arm} (\code{factor})\cr the treatment group variable.
\item \code{strat} (\code{character} or \code{NULL})\cr variable names indicating stratification factors.
}}

\item{control_surv}{(\code{list})\cr parameters for comparison details, specified by using
the helper function \code{\link[=control_surv_timepoint]{control_surv_timepoint()}}. Some possible parameter options are:
\itemize{
\item \code{conf_level} (\code{proportion})\cr confidence level of the interval for survival rate.
\item \code{conf_type} (\code{string})\cr \code{"plain"} (default), \code{"log"}, \code{"log-log"} for confidence interval type,
see more in \code{\link[survival:survfit]{survival::survfit()}}. Note that the option "none" is no longer supported.
}}

\item{col}{(\code{character})\cr lines colors. Length of a vector should be equal
to number of strata from \code{\link[survival:survfit]{survival::survfit()}}.}

\item{lty}{(\code{numeric})\cr line type. Length of a vector should be equal
to number of strata from \code{\link[survival:survfit]{survival::survfit()}}.}

\item{lwd}{(\code{numeric})\cr line width. Length of a vector should be equal
to number of strata from \code{\link[survival:survfit]{survival::survfit()}}.}

\item{censor_show}{(\code{flag})\cr whether to show censored.}

\item{pch}{(\code{numeric}, \code{string})\cr value or character of points symbol to indicate censored cases.}

\item{size}{(\code{numeric})\cr size of censored point, a class of \code{unit}.}

\item{max_time}{(\code{numeric})\cr maximum value to show on X axis. Only data values less than or up to
this threshold value will be plotted (defaults to \code{NULL}).}

\item{xticks}{(\code{numeric}, \code{number}, or \code{NULL})\cr numeric vector of ticks or single number with spacing
between ticks on the x axis. If \code{NULL} (default), \code{\link[labeling:extended]{labeling::extended()}} is used to determine
an optimal tick position on the x axis.}

\item{xlab}{(\code{string})\cr label of x-axis.}

\item{yval}{(\code{string})\cr value of y-axis. Options are \code{Survival} (default) and \code{Failure} probability.}

\item{ylab}{(\code{string})\cr label of y-axis.}

\item{ylim}{(\code{vector} of \code{numeric})\cr vector of length 2 containing lower and upper limits for the y-axis.
If \code{NULL} (default), the minimum and maximum y-values displayed are used as limits.}

\item{title}{(\code{string})\cr title for plot.}

\item{footnotes}{(\code{string})\cr footnotes for plot.}

\item{draw}{(\code{flag})\cr whether the plot should be drawn.}

\item{newpage}{(\code{flag})\cr whether the plot should be drawn on a new page.
Only considered if \code{draw = TRUE} is used.}

\item{gp}{A \code{"gpar"} object, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}

\item{vp}{a \code{\link[grid]{viewport}} object (or \code{NULL}).}

\item{name}{a character identifier for the grob.  Used to find the
    grob on the display list and/or as a child of another grob. }

\item{font_size}{(\code{number})\cr font size to be used.}

\item{ci_ribbon}{(\code{flag})\cr draw the confidence interval around the Kaplan-Meier curve.}

\item{ggtheme}{(\code{theme})\cr a graphical theme as provided by \code{ggplot2} to control outlook of the Kaplan-Meier curve.}

\item{annot_at_risk}{(\code{flag})\cr compute and add the annotation table reporting the number of patient at risk
matching the main grid of the Kaplan-Meier curve.}

\item{annot_surv_med}{(\code{flag})\cr compute and add the annotation table on the Kaplan-Meier curve estimating the
median survival time per group.}

\item{annot_coxph}{(\code{flag})\cr add the annotation table from a \code{\link[survival:coxph]{survival::coxph()}} model.}

\item{annot_stats}{(\code{string})\cr statistics annotations to add to the plot. Options are
\code{median} (median survival follow-up time) and \code{min} (minimum survival follow-up time).}

\item{annot_stats_vlines}{(\code{flag})\cr add vertical lines corresponding to each of the statistics
specified by \code{annot_stats}. If \code{annot_stats} is \code{NULL} no lines will be added.}

\item{control_coxph_pw}{(\code{list})\cr parameters for comparison details, specified by using
the helper function \code{\link[=control_coxph]{control_coxph()}}. Some possible parameter options are:
\itemize{
\item \code{pval_method} (\code{string})\cr p-value method for testing hazard ratio = 1.
Default method is \code{"log-rank"}, can also be set to \code{"wald"} or \code{"likelihood"}.
\item \code{ties} (\code{string})\cr method for tie handling. Default is \code{"efron"},
can also be set to \code{"breslow"} or \code{"exact"}. See more in \code{\link[survival:coxph]{survival::coxph()}}
\item \code{conf_level} (\code{proportion})\cr confidence level of the interval for HR.
}}

\item{position_coxph}{(\code{numeric})\cr x and y positions for plotting \code{\link[survival:coxph]{survival::coxph()}} model.}

\item{position_surv_med}{(\code{numeric})\cr x and y positions for plotting annotation table estimating median survival
time per group.}

\item{width_annots}{(named \code{list} of \code{unit}s)\cr a named list of widths for annotation tables with names \code{surv_med}
(median survival time table) and \code{coxph} (\code{\link[survival:coxph]{survival::coxph()}} model table), where each value is the width
(in units) to implement when printing the annotation table.}
}
\value{
A \code{grob} of class \code{gTree}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

From a survival model, a graphic is rendered along with tabulated annotation
including the number of patient at risk at given time and the median survival
per group.
}
\examples{
\donttest{
library(dplyr)
library(ggplot2)
library(survival)
library(grid)
library(nestcolor)

df <- tern_ex_adtte \%>\%
  filter(PARAMCD == "OS") \%>\%
  mutate(is_event = CNSR == 0)
variables <- list(tte = "AVAL", is_event = "is_event", arm = "ARMCD")

# 1. Example - basic option

res <- g_km(df = df, variables = variables)
res <- g_km(df = df, variables = variables, yval = "Failure")
res <- g_km(
  df = df,
  variables = variables,
  control_surv = control_surv_timepoint(conf_level = 0.9),
  col = c("grey25", "grey50", "grey75")
)
res <- g_km(df = df, variables = variables, ggtheme = theme_minimal())
res <- g_km(df = df, variables = variables, ggtheme = theme_minimal(), lty = 1:3)
res <- g_km(df = df, variables = variables, max = 2000)
res <- g_km(
  df = df,
  variables = variables,
  annot_stats = c("min", "median"),
  annot_stats_vlines = TRUE
)

# 2. Example - Arrange several KM curve on a single graph device

# 2.1 Use case: A general graph on the top, a zoom on the bottom.
grid.newpage()
lyt <- grid.layout(nrow = 2, ncol = 1) \%>\%
  viewport(layout = .) \%>\%
  pushViewport()

res <- g_km(
  df = df, variables = variables, newpage = FALSE, annot_surv_med = FALSE,
  vp = viewport(layout.pos.row = 1, layout.pos.col = 1)
)
res <- g_km(
  df = df, variables = variables, max = 1000, newpage = FALSE, annot_surv_med = FALSE,
  ggtheme = theme_dark(),
  vp = viewport(layout.pos.row = 2, layout.pos.col = 1)
)

# 2.1 Use case: No annotations on top, annotated graph on bottom
grid.newpage()
lyt <- grid.layout(nrow = 2, ncol = 1) \%>\%
  viewport(layout = .) \%>\%
  pushViewport()

res <- g_km(
  df = df, variables = variables, newpage = FALSE,
  annot_surv_med = FALSE, annot_at_risk = FALSE,
  vp = viewport(layout.pos.row = 1, layout.pos.col = 1)
)
res <- g_km(
  df = df, variables = variables, max = 2000, newpage = FALSE, annot_surv_med = FALSE,
  annot_at_risk = TRUE,
  ggtheme = theme_dark(),
  vp = viewport(layout.pos.row = 2, layout.pos.col = 1)
)

# Add annotation from a pairwise coxph analysis
g_km(
  df = df, variables = variables,
  annot_coxph = TRUE
)

# Change widths/sizes of surv_med and coxph annotation tables.
g_km(
  df = df, variables = c(variables, list(strat = "SEX")),
  annot_coxph = TRUE,
  width_annots = list(surv_med = grid::unit(2, "in"), coxph = grid::unit(3, "in"))
)

g_km(
  df = df, variables = c(variables, list(strat = "SEX")),
  font_size = 15,
  annot_coxph = TRUE,
  control_coxph = control_coxph(pval_method = "wald", ties = "exact", conf_level = 0.99),
  position_coxph = c(0.5, 0.5)
)

# Change position of the treatment group annotation table.
g_km(
  df = df, variables = c(variables, list(strat = "SEX")),
  font_size = 15,
  annot_coxph = TRUE,
  control_coxph = control_coxph(pval_method = "wald", ties = "exact", conf_level = 0.99),
  position_surv_med = c(1, 0.7)
)
}

}
