% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorate_grob.R
\name{split_text_grob}
\alias{split_text_grob}
\title{Split Text According To Available Text Width}
\usage{
split_text_grob(
  text,
  x = grid::unit(0.5, "npc"),
  y = grid::unit(0.5, "npc"),
  width = grid::unit(1, "npc"),
  just = "centre",
  hjust = NULL,
  vjust = NULL,
  default.units = "npc",
  name = NULL,
  gp = grid::gpar(),
  vp = NULL
)
}
\arguments{
\item{text}{character string}

\item{x}{A numeric vector or unit object specifying x-values.}

\item{y}{A numeric vector or unit object specifying y-values.}

\item{width}{a unit object specifying max width of text}

\item{just}{The justification of the text
    relative to its (x, y) location.  If there are two values, the first
    value specifies horizontal justification and the second value specifies
    vertical justification.  Possible string values are: \code{"left"},
    \code{"right"}, \code{"centre"}, \code{"center"}, \code{"bottom"},
    and \code{"top"}.  For numeric values, 0 means left (bottom) alignment
    and 1 means right (top) alignment.
  }

\item{hjust}{A numeric vector specifying horizontal justification.
    If specified, overrides the \code{just} setting.}

\item{vjust}{A numeric vector specifying vertical justification.
    If specified, overrides the \code{just} setting.}

\item{default.units}{A string indicating the default units to use
    if \code{x} or \code{y}
    are only given as numeric vectors.}

\item{name}{ A character identifier. }

\item{gp}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
A text grob.
}
\description{
Dynamically wrap text.
}
\details{
This code is taken from \verb{R Graphics by Paul Murell, 2nd edition}
}
\keyword{internal}
