% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abnormal_by_worst_grade_worsen.R
\name{h_adlb_worsen}
\alias{h_adlb_worsen}
\title{Helper Function to Prepare \code{ADLB} with Worst Labs}
\usage{
h_adlb_worsen(
  adlb,
  worst_flag_low = NULL,
  worst_flag_high = NULL,
  direction_var
)
}
\arguments{
\item{adlb}{(\code{data.frame})\cr \code{ADLB} dataframe}

\item{worst_flag_low}{(named \code{vector})\cr Worst low post-baseline lab grade flag variable}

\item{worst_flag_high}{(named \code{vector})\cr Worst high post-baseline lab grade flag variable}

\item{direction_var}{(\code{string})\cr Direction variable specifying the direction of the shift table of interest.
Only lab records flagged by \code{L}, \code{H} or \code{B} are included in the shift table.
\itemize{
\item \code{L}: low direction only
\item \code{H}: high direction only
\item \code{B}: both low and high directions
}}
}
\value{
\code{h_adlb_worsen()} returns the \code{adlb} \code{data.frame} containing only the
worst labs specified according to \code{worst_flag_low} or \code{worst_flag_high} for the
direction specified according to \code{direction_var}. For instance, for a lab that is
needed for the low direction only, only records flagged by \code{worst_flag_low} are
selected. For a lab that is needed for both low and high directions, the worst
low records are selected for the low direction, and the worst high record are selected
for the high direction.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Helper function to prepare a \code{df} for generate the patient count shift table
}
\examples{
library(dplyr)

# The direction variable, GRADDR, is based on metadata
adlb <- tern_ex_adlb \%>\%
  mutate(
    GRADDR = case_when(
      PARAMCD == "ALT" ~ "B",
      PARAMCD == "CRP" ~ "L",
      PARAMCD == "IGA" ~ "H"
    )
  ) \%>\%
  filter(SAFFL == "Y" & ONTRTFL == "Y" & GRADDR != "")

df <- h_adlb_worsen(
  adlb,
  worst_flag_low = c("WGRLOFL" = "Y"),
  worst_flag_high = c("WGRHIFL" = "Y"),
  direction_var = "GRADDR"
)

}
\seealso{
\link{abnormal_by_worst_grade_worsen}
}
