% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response_biomarkers_subgroups.R
\name{extract_rsp_biomarkers}
\alias{extract_rsp_biomarkers}
\title{Prepares Response Data Estimates for Multiple Biomarkers in a Single Data Frame}
\usage{
extract_rsp_biomarkers(
  variables,
  data,
  groups_lists = list(),
  control = control_logistic(),
  label_all = "All Patients"
)
}
\arguments{
\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{data}{(\code{data.frame})\cr the dataset containing the variables to summarize.}

\item{groups_lists}{(named \code{list} of \code{list})\cr optionally contains for each \code{subgroups} variable a
list, which specifies the new group levels via the names and the
levels that belong to it in the character vectors that are elements of the list.}

\item{control}{(named \code{list})\cr controls for the response definition and the
confidence level produced by \code{\link[=control_logistic]{control_logistic()}}.}

\item{label_all}{(\code{string})\cr label for the total population analysis.}
}
\value{
A \code{data.frame} with columns \code{biomarker}, \code{biomarker_label}, \code{n_tot}, \code{n_rsp},
\code{prop}, \code{or}, \code{lcl}, \code{ucl}, \code{conf_level}, \code{pval}, \code{pval_label}, \code{subgroup}, \code{var},
\code{var_label}, and \code{row_type}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Prepares estimates for number of responses, patients and overall response rate,
as well as odds ratio estimates, confidence intervals and p-values,
for multiple biomarkers across population subgroups in a single data frame.
\code{variables} corresponds to the names of variables found in \code{data}, passed as a
named list and requires elements \code{rsp} and \code{biomarkers} (vector of continuous
biomarker variables) and optionally \code{covariates}, \code{subgroups} and \code{strat}.
\code{groups_lists} optionally specifies groupings for \code{subgroups} variables.
}
\note{
You can also specify a continuous variable in \code{rsp} and then use the
\code{response_definition} control to convert that internally to a logical
variable reflecting binary response.
}
\examples{
library(dplyr)
library(forcats)

adrs <- tern_ex_adrs
adrs_labels <- formatters::var_labels(adrs)

adrs_f <- adrs \%>\%
  filter(PARAMCD == "BESRSPI") \%>\%
  mutate(rsp = AVALC == "CR")

# Typical analysis of two continuous biomarkers `BMRKR1` and `AGE`,
# in logistic regression models with one covariate `RACE`. The subgroups
# are defined by the levels of `BMRKR2`.
df <- extract_rsp_biomarkers(
  variables = list(
    rsp = "rsp",
    biomarkers = c("BMRKR1", "AGE"),
    covariates = "SEX",
    subgroups = "BMRKR2"
  ),
  data = adrs_f
)
df

# Here we group the levels of `BMRKR2` manually, and we add a stratification
# variable `STRATA1`. We also here use a continuous variable `EOSDY`
# which is then binarized internally (response is defined as this variable
# being larger than 500).
df_grouped <- extract_rsp_biomarkers(
  variables = list(
    rsp = "EOSDY",
    biomarkers = c("BMRKR1", "AGE"),
    covariates = "SEX",
    subgroups = "BMRKR2",
    strat = "STRATA1"
  ),
  data = adrs_f,
  groups_lists = list(
    BMRKR2 = list(
      "low" = "LOW",
      "low/medium" = c("LOW", "MEDIUM"),
      "low/medium/high" = c("LOW", "MEDIUM", "HIGH")
    )
  ),
  control = control_logistic(
    response_definition = "I(response > 500)"
  )
)
df_grouped

}
\seealso{
\code{\link[=h_logistic_mult_cont_df]{h_logistic_mult_cont_df()}} which is used internally.
}
