% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combination_function.R
\docType{class}
\name{combination_function}
\alias{combination_function}
\alias{CombinationFunction}
\alias{CombinationFunction-class}
\alias{&,CombinationFunction,CombinationFunction-method}
\alias{|,CombinationFunction,CombinationFunction-method}
\alias{!,CombinationFunction-method}
\title{Combination Functions Class}
\usage{
\S4method{&}{CombinationFunction,CombinationFunction}(e1, e2)

\S4method{|}{CombinationFunction,CombinationFunction}(e1, e2)

\S4method{!}{CombinationFunction}(x)
}
\arguments{
\item{e1}{(\code{CombinationFunction})\cr left hand side of logical operator.}

\item{e2}{(\code{CombinationFunction})\cr right hand side of logical operator.}

\item{x}{(\code{CombinationFunction})\cr the function which should be negated.}
}
\value{
Returns a logical value indicating whether the left hand side of the equation equals the right hand side.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{CombinationFunction} is an S4 class which extends standard functions. These are special functions that
can be combined and negated with the logical operators.
}
\section{Functions}{
\itemize{
\item \code{e1 & e2}: Logical "AND" combination of \code{CombinationFunction} functions.
The resulting object is of the same class, and evaluates the two argument functions. The result
is then the "AND" of the two individual results.

\item \code{e1 | e2}: Logical "OR" combination of \code{CombinationFunction} functions.
The resulting object is of the same class, and evaluates the two argument functions. The result
is then the "OR" of the two individual results.

\item \code{`!`(CombinationFunction)}: Logical negation of \code{CombinationFunction} functions.
The resulting object is of the same class, and evaluates the original function. The result
is then the opposite of this results.

}}
\examples{
higher <- function(a) {
  force(a)
  CombinationFunction(
    function(x) {
      x > a
    }
  )
}

lower <- function(b) {
  force(b)
  CombinationFunction(
    function(x) {
      x < b
    }
  )
}

c1 <- higher(5)
c2 <- lower(10)
c3 <- higher(5) & lower(10)
c3(7)

}
