% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_functions.R
\name{analyze_functions}
\alias{analyze_functions}
\title{Analyze Functions}
\description{
These functions are wrappers of \code{\link[rtables:analyze]{rtables::analyze()}} which apply corresponding \code{tern} statistics functions
to add an analysis to a given table layout:
\itemize{
\item \code{\link[=analyze_num_patients]{analyze_num_patients()}}
\item \code{\link[=compare_vars]{compare_vars()}}
\item \code{\link[=count_abnormal]{count_abnormal()}}
\item \code{\link[=count_abnormal_by_baseline]{count_abnormal_by_baseline()}}
\item \code{\link[=count_abnormal_by_marked]{count_abnormal_by_marked()}}
\item \code{\link[=count_abnormal_by_worst_grade]{count_abnormal_by_worst_grade()}}
\item \code{\link[=count_cumulative]{count_cumulative()}}
\item \code{\link[=count_missed_doses]{count_missed_doses()}}
\item \code{\link[=count_occurrences]{count_occurrences()}}
\item \code{\link[=count_occurrences_by_grade]{count_occurrences_by_grade()}}
\item \code{\link[=count_patients_events_in_cols]{count_patients_events_in_cols()}}
\item \code{\link[=count_patients_with_event]{count_patients_with_event()}}
\item \code{\link[=count_patients_with_flags]{count_patients_with_flags()}}
\item \code{\link[=count_values]{count_values()}}
\item \code{\link[=coxph_pairwise]{coxph_pairwise()}}
\item \code{\link[=estimate_incidence_rate]{estimate_incidence_rate()}}
\item \code{\link[=estimate_multinomial_rsp]{estimate_multinomial_rsp()}}
\item \code{\link[=estimate_odds_ratio]{estimate_odds_ratio()}}
\item \code{\link[=estimate_proportion]{estimate_proportion()}}
\item \code{\link[=estimate_proportion_diff]{estimate_proportion_diff()}}
\item \code{\link[=summarize_ancova]{summarize_ancova()}}
\item \code{\link[=summarize_colvars]{summarize_colvars()}}: even if this function uses \code{\link[rtables:analyze_colvars]{rtables::analyze_colvars()}},
it applies the analysis methods as different rows for one or more
variables that are split into different columns. In comparison, \link{analyze_colvars_functions}
leverage \code{analyze_colvars} to have the context split in rows and the analysis
methods in columns.
\item \code{\link[=summarize_change]{summarize_change()}}
\item \code{\link[=summarize_vars]{summarize_vars()}}
\item \code{\link[=surv_time]{surv_time()}}
\item \code{\link[=surv_timepoint]{surv_timepoint()}}
\item \code{\link[=test_proportion_diff]{test_proportion_diff()}}
}
}
\seealso{
\itemize{
\item \link{summarize_functions} for functions which are wrappers for \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}.
\item \link{analyze_colvars_functions} for functions that are wrappers for \code{\link[rtables:analyze_colvars]{rtables::analyze_colvars()}}.
}
}
