% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsmeans.R
\name{lsmeans}
\alias{lsmeans}
\alias{lsmeans.tern_gee_logistic}
\title{Extract Least Square Means from a GEE Model}
\usage{
lsmeans(object, conf_level = 0.95, weights = "proportional", ...)

\method{lsmeans}{tern_gee_logistic}(object, conf_level = 0.95, weights = "proportional", ...)
}
\arguments{
\item{object}{(\code{tern_gee})\cr result of \code{\link[=fit_gee]{fit_gee()}}.}

\item{conf_level}{(\code{proportion})\cr confidence level}

\item{weights}{(\code{string})\cr type of weights to be used for the least square means,
see \code{\link[emmeans:emmeans]{emmeans::emmeans()}} for details.}

\item{...}{additional arguments for methods}
}
\value{
A \code{data.frame} with least-square means and contrasts. Additional
classes allow to dispatch downstream methods correctly, too.
}
\description{
Extract Least Square Means from a GEE Model
}
\examples{
df <- fev_data
df$AVAL <- rbinom(n = nrow(df), size = 1, prob = 0.5)
fit <- fit_gee(vars = vars_gee(arm = "ARMCD"), data = df)

lsmeans(fit)

lsmeans(fit, conf_level = 0.90, weights = "equal")
}
