% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_gee.R
\name{fit_gee}
\alias{fit_gee}
\title{Fit a GEE Model}
\usage{
fit_gee(
  vars = vars_gee(),
  data,
  regression = c("logistic"),
  cor_struct = c("unstructured", "toeplitz", "compound symmetry", "auto-regressive")
)
}
\arguments{
\item{vars}{(\code{list})\cr see \code{\link[=vars_gee]{vars_gee()}}.}

\item{data}{(\code{data.frame})\cr input data.}

\item{regression}{(\code{string})\cr choice of regression model.}

\item{cor_struct}{(\code{string})\cr assumed correlation structure.}
}
\value{
Object of class \code{tern_gee} as well as specific to the kind of regression
which was used.
}
\description{
Fit a GEE Model
}
\details{
The correlation structure can be:
\itemize{
\item \code{unstructured}: No constraints are placed on the correlations.
\item \code{toeplitz}: Assumes a banded correlation structure, i.e. the correlation
between two time points depends on the distance between the time indices.
\item \verb{compound symmetry}: Constant correlation between all time points.
\item \code{auto-regressive}: Auto-regressive order 1 correlation matrix.
}
}
\examples{
df <- fev_data
df$AVAL <- as.integer(fev_data$FEV1 > 30)

fit_gee(vars = vars_gee(arm = "ARMCD"), data = df)

fit_gee(vars = vars_gee(arm = "ARMCD"), data = df, cor_struct = "compound symmetry")
}
