% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-term-rcrd.R
\name{as_term_rcrd}
\alias{as_term_rcrd}
\alias{as_term_rcrd.character}
\alias{as_term_rcrd.numeric}
\alias{as_term_rcrd.term}
\title{Coerce to a Term Record}
\usage{
as_term_rcrd(x, ...)

\method{as_term_rcrd}{character}(x, repair = FALSE, ...)

\method{as_term_rcrd}{numeric}(x, name = "par", ...)

\method{as_term_rcrd}{term}(x, repair = FALSE, ...)
}
\arguments{
\item{x}{The object.}

\item{...}{Unused.}

\item{repair}{A flag specifying whether to repair terms.}

\item{name}{A string specifying the name of the parameter.}
}
\description{
Coerces an R object to a \code{term_rcrd}.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: Coerce character vector to term_rcrd

\item \code{numeric}: Coerce numeric vector to term_rcrd

\item \code{term}: Coerce term vector to term_rcrd
}}

\examples{
as_term(matrix(1:4, 2))
as_term(c("parm3[10]", "parm3[2]", "parm[2,2]", "parm[1,1]"))
}
\seealso{
\code{\link[=repair_terms]{repair_terms()}}
}
