context("is-inconsistent-terms")

test_that("is.inconsistent_terms", {
  expect_false(is.inconsistent_terms(term(0L)))
  expect_false(is.inconsistent_terms(as.term("b")))
  expect_error(is.inconsistent_terms(as.term(c("b", NA))), NA)
  expect_false(is.inconsistent_terms(as.term(c("b", "b[2]"))))
  expect_true(is.inconsistent_terms(as.term(c("b", "b[2]", "b[4,] "))))
  expect_true(is.inconsistent_terms(as.term(c("b[1]", "b[1,1]"))))
  expect_false(is.inconsistent_terms(as.term("b[1]")))
  expect_false(is.inconsistent_terms(as.term("b[2]")))
  expect_false(is.inconsistent_terms(as.term(c("b[2]", "b"))))
  expect_false(is.inconsistent_terms(as.term(c("a[1,1]", "a[1,2]", "a[2,1]", "a[2,2]"))))
  expect_false(is.inconsistent_terms(as.term(c("a[1,1]", "a[1,2]", "a[2,1]"))))
})
