% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{set_vertex_attribute}
\alias{set_vertex_attribute}
\title{Set Vertex Attribute on Network Object}
\usage{
set_vertex_attribute(x, attrname, value, v)
}
\arguments{
\item{x}{An object of class network.}

\item{attrname}{The name of the attribute to set.}

\item{value}{A vector of values of the attribute to be set.}

\item{v}{IDs for the vertices whose attributes are to be altered.}
}
\value{
Returns an object of class \code{network}.
}
\description{
Set a vertex attribute on an object of class \code{network},
             wrapping the related function in the \code{network} package.
}
\details{
This function is used in \code{EpiModel} workflows to set vertex attributes on
an initialized empty network object (with \code{\link{network_initialize}}.
}
\examples{
nw <- network_initialize(100)
nw <- set_vertex_attribute(nw, "age", runif(100, 15, 65))
nw

}
