% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_tensor.R
\name{mhalf}
\alias{mhalf}
\title{The symmetric square root of a positive definite matrix.}
\usage{
mhalf(M)
}
\arguments{
\item{M}{A symmetric positive definite matrix.}
}
\value{
The unique symmetric positive definite matrix \eqn{X} such
    that \eqn{XX = M}.
}
\description{
Returns the unique symmetric positive definite square root matrix
of a provided symmetric positive definite matrix.
}
\examples{
Y <- matrix(stats::rnorm(4), nrow = 2)
M <- Y \%*\% t(Y)
X <- mhalf(M)
X
identical(M, X \%*\% X)
}
\author{
Peter Hoff.
}
