% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_decompositions.R
\name{ihop}
\alias{ihop}
\title{The incredible higher-order polar decomposition (IHOP).}
\usage{
ihop(X, itermax = 100, tol = 10^-9, print_diff = TRUE, mode_rep = NULL,
  use_sig = TRUE)
}
\arguments{
\item{X}{An array of numerics.}

\item{itermax}{An integer. The maximum number of iterations to perform during
the optimization procedure.}

\item{tol}{A numeric. The algorithm will stop when the Frobenius norm of the
difference of core arrays between subsequent iterations is below \code{tol}
(for \code{use_sig = FALSE}) or when the absolute difference between the
ratio of subsequent values of \code{sig} and 1 is less than \code{tol} (for
\code{use_sig = TRUE}).}

\item{print_diff}{A logical. Should we print the updates of the algorithm?}

\item{mode_rep}{A vector. Which component matrices should be set to be the
identity?}

\item{use_sig}{A logical. See \code{tol}.}
}
\value{
\code{R} A core array which, in combination with \code{L}, has
  certain orthogonality properties.

  \code{L} A list of lower triangular matrices with unit Frobenius norm.

  \code{sig} A numeric.
}
\description{
Mmm, pancakes.
}
\details{
This function will calculate the higher-order polar decomposition, a
generalization of the polar decomposition to tensors. It generalizes a
minimization formulation of the polar decomposition.

Given an array \code{X}, \code{ihop} will output \code{L} a list of lower
triangular matrices with positive diagonal elements and unit Frobenius norm,
\code{R} a core array with certain orthogonality properties, and \code{sig} a
total variation parameter. We have that \code{X} is equal to \code{sig *
atrans(R, L)} up to numerical precision.

\code{t(solve(L[[i]])) \%*\% mat(R, i)} will have orthonormal rows for all
\code{i}.

For more details on the IHOP, see
\href{http://arxiv.org/abs/1410.1094}{Gerard and Hoff (2014)}.
}
\examples{
#Generate random data.
p <- c(2, 3, 4)
X <- array(stats::rnorm(prod(p)), dim = p)

#Calculate IHOP.
ihop_x <- ihop(X)
R <- ihop_x$R
L <- ihop_x$L
sig <- ihop_x$sig

#Reconstruct X
trim(X - sig * atrans(R, L))

#Orthogonality properties
ortho_1 <- t(solve(L[[1]])) \%*\% mat(R, 1)
trim(ortho_1 \%*\% t(ortho_1))

ortho_2 <- t(solve(L[[2]])) \%*\% mat(R, 2)
trim(ortho_2 \%*\% t(ortho_2))

ortho_3 <- t(solve(L[[3]])) \%*\% mat(R, 3)
trim(ortho_3 \%*\% t(ortho_3))
}
\author{
David Gerard.
}
\references{
Gerard, D. C., & Hoff, P. D. (2014).
  \href{http://arxiv.org/abs/1410.1094}{A higher-order LQ decomposition for
  separable covariance models}. \emph{arXiv preprint arXiv:1410.1094.}
}
\keyword{decompositions}

