% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hoff_functions.R
\name{anorm_cd}
\alias{anorm_cd}
\title{Array normal conditional distributions.}
\usage{
anorm_cd(Y, M, S, saidx)
}
\arguments{
\item{Y}{A real valued array.}

\item{M}{Mean of \code{Y}.}

\item{S}{List of mode-specific covariance matrices of \code{Y}.}

\item{saidx}{List of indices for indexing sub-array for which the conditional
mean and variance should be computed. For example, \code{said_x = list(1:2,
1:2, 1:2)} will compute the conditional means and variances for the \eqn{2}
by \eqn{2} by \eqn{2} sub-array Y[1:2, 1:2, 1:2]. This is conditional on
every other element in \code{Y}.}
}
\description{
Conditional mean and variance of a subarray.
}
\details{
This function calculates the conditional mean and variance in the array
normal model. Let \eqn{Y} be array normal and let \eqn{Y_a} be a subarray of
\eqn{Y}. Then this function will calculate the conditional means and
variances of \eqn{Y_a}, conditional on every other element in \eqn{Y}.
}
\examples{
p <- c(4, 4, 4)
Y <- array(stats::rnorm(prod(p)), dim = p)
saidx <- list(1:2, 1:2, 1:2)
true_cov <- tensr::start_ident(p)
true_mean <- array(0, dim = p)
cond_params <- anorm_cd(Y = Y, M = true_mean, S = true_cov, saidx = saidx)

## Since data are independent standard normals, conditional mean is 0 and
##    conditional covariance matrices are identities.
cond_params$Mab
cond_params$Sab
}
\author{
Peter Hoff.
}
\references{
Hoff, P. D. (2011).
  \href{http://arxiv.org/abs/1008.2169}{Separable covariance arrays via the
  Tucker product, with applications to multivariate relational data}.
  \emph{Bayesian Analysis}, 6(2), 179-196.
}
\keyword{multivariate}

