% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tenAR.r
\name{tenAR.est}
\alias{tenAR.est}
\title{Estimation for Autoregressive Model of Tensor-Valued Time Series}
\usage{
tenAR.est(xx,R=1,P=1,method="LSE",init.A=NULL,init.sig=NULL,niter=500,tol=1e-6)
}
\arguments{
\item{xx}{\eqn{T \times d_1 \times \cdots \times d_K} tensor-valued time series, \eqn{T} is the length of the series.}

\item{R}{Kronecker rank for each lag.}

\item{P}{Autoregressive order.}

\item{method}{character string, specifying the type of the estimation method to be used. \describe{
 \item{\code{"PROJ",}}{Projection method.}
 \item{\code{"LSE",}}{Least squares.}
 \item{\code{"MLE",}}{MLE under a separable cov(vec(\eqn{E_t})).}
 \item{\code{"VAR",}}{VAR(\eqn{P}) model for the \eqn{\mathrm{vec}(E_t)}.}
}}

\item{init.A}{initial values of coefficient matrices \eqn{A_k^{(ir)}} in estimation algorithms, which is a multi-layer list such that
the first layer for the lag \eqn{1 \le i \le P}, the second the term \eqn{1 \le r \le R}, and the third the mode \eqn{1 \le k \le K}.
See "Details". By default, we use PROJ estimators as initial values.}

\item{init.sig}{only if \code{method=MLE}, a list of initial values of \eqn{\Sigma_1,\ldots,\Sigma_K}. The default are identity matrices.}

\item{niter}{maximum number of iterations if error stays above \code{tol}.}

\item{tol}{error tolerance in terms of the Frobenius norm.}
}
\value{
return a list containing the following:\describe{
\item{\code{A}}{a list of estimated coefficient matrices \eqn{A_k^{(ir)}}. It is a multi-layer list,
the first layer for the lag \eqn{1 \le i \le P}, the second the term \eqn{1 \le r \le R}, and the third the mode \eqn{1 \le k \le K}. See "Details".}
\item{\code{SIGMA}}{only if \code{method=MLE}, a list of estimated \eqn{\Sigma_1,\ldots,\Sigma_K}.}
\item{\code{res}}{residuals}
\item{\code{Sig}}{covariance matrix \eqn{\mathrm{cov}(\mathrm{vec}({E_t}))}.}
\item{\code{cov}}{grand covariance matrix of all estimated entries of \eqn{A_k^{(ir)}}}
\item{\code{sd}}{standard errors of the coefficient matrices \eqn{A_k^{(ir)}}, returned as a list aligned with \code{A}.}
\item{\code{niter}}{number of iterations.}
\item{\code{BIC}}{value of extended Bayesian information criterion.}
}
}
\description{
Estimation function for tensor autoregressive models. Methods include
projection (PROJ), Least Squares (LSE), maximum likelihood estimation (MLE)
and vector autoregressive model (VAR), as determined by the value of \code{method}.
}
\details{
Tensor autoregressive model (of autoregressive order one) has the form:
\deqn{X_t = \sum_{r=1}^R X_{t-1} \times_{1}  A_1^{(r)} \times_{2}  \cdots \times_{K} A_K^{(r)} + E_t,}
where \eqn{A_k^{(r)}} are \eqn{d_k \times d_k} coefficient matrices, \eqn{k=1,\cdots,K}, and \eqn{E_t} is a tensor white noise. \eqn{R} is the Kronecker rank.
The model of autoregressive order \eqn{P} takes the form
\deqn{X_t = \sum_{i=1}^{P} \sum_{r=1}^{R_i} X_{t-i} \times_{1} A_{1}^{(ir)} \times_{2}  \cdots \times_{K} A_{K}^{(ir)} + E_t.}
For the "MLE" method, we also assume,
 \deqn{\mathrm{Cov}(\mathrm{vec}(E_t))= \Sigma_K \otimes \Sigma_{K-1} \otimes \cdots \otimes \Sigma_1,}
}
\examples{
set.seed(333)
dim <- c(2,2,2)
xx <- tenAR.sim(t=100, dim,R=2,P=1,rho=0.5, cov='iid')
est <- tenAR.est(xx, R=2, P=1, method="LSE")
A <- est$A # A is a multi-layer list

length(A) == 1 # TRUE, since the order P = 1
length(A[[1]]) == 2 # TRUE, since the number of terms R = 2
length(A[[1]][[1]]) == 3 # TRUE, since the mode K = 3
}
\references{
Rong Chen, Han Xiao, and Dan Yang. "Autoregressive models for matrix-valued time series". Journal of Econometrics, 2020.
}
