\name{tensorBSS-package}
\alias{tensorBSS-package}
\alias{tensorBSS}
\docType{package}
\title{
Blind Source Separation Methods for Tensor-Valued Observations
}
\description{
Contains several utility functions for manipulating tensor-valued data (centering, multiplication from a single mode etc.) and 
the implementations of the following blind source separation methods for tensor-valued data: \sQuote{tPCA}, \sQuote{tFOBI}, \sQuote{tJADE}, \sQuote{k-tJADE}, \sQuote{tgFOBI}, \sQuote{tgJADE}, \sQuote{tSOBI}, \sQuote{tNSS.SD}, \sQuote{tNSS.JD}, \sQuote{tNSS.TD.JD} and \sQuote{tPP}.
}
\details{
\tabular{ll}{
Package: \tab tensorBSS\cr
Type: \tab Package\cr
Version: \tab 0.3.4\cr
Date: \tab 2018-03-01\cr
License: \tab GPL (>= 2)\cr
}


}
\author{
Joni Virta, Bing Li, Klaus Nordhausen and Hannu Oja 

Maintainer: Joni Virta <joni.virta@outlook.com>
}

\references{
\cite{Virta, J., Taskinen, S. and Nordhausen, K. (2016), Applying fully tensorial ICA to fMRI data, Signal Processing in Medicine and Biology Symposium (SPMB), 2016 IEEE, \doi{10.1109/SPMB.2016.7846858}} 

\cite{Virta, J., Li, B., Nordhausen, K. and Oja, H., (2017), Independent component analysis for tensor-valued data, Journal of Multivariate Analysis, \doi{10.1016/j.jmva.2017.09.008}}

\cite{Virta, J., Li, B., Nordhausen, K. and Oja, H., (2017), JADE for Tensor-Valued Observation, to appear in Journal of Computational and Graphical Statistics. preprint available on ArXiv {http://arxiv.org/abs/1603.05406}.}

\cite{Virta, J. and Nordhausen, K., (2017), Blind source separation of tensor-valued time series. Signal Processing 141, 204-216, \doi{10.1016/j.sigpro.2017.06.008}}  

\cite{Virta J., Nordhausen K. (2017): Blind source separation for nonstationary tensor-valued time series, 2017 IEEE 27th International Workshop on Machine Learning for Signal Processing (MLSP), \doi{10.1109/MLSP.2017.8168122}}
}
\keyword{ package }
\keyword{multivariate}
\keyword{ts}
\keyword{array}


