% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{UpdateTheta_FCtemplateICAcpp}
\alias{UpdateTheta_FCtemplateICAcpp}
\title{Update parameters (M-step of the EM)}
\usage{
UpdateTheta_FCtemplateICAcpp(
  template_mean,
  template_var,
  template_FC,
  G,
  prior_params,
  BOLD,
  Y_sq_sum,
  post_sums,
  sigma2_alpha,
  verbose
)
}
\arguments{
\item{template_mean}{a matrix with dimensions V x Q giving the mean value
of the independent components}

\item{template_var}{a matrix with dimensions V x Q giving the variance
of the independent components}

\item{template_FC}{a list with two elements: psi, a Q x Q matrix, and nu, a
scalar. These two values are the parameters of the Wishart prior on G}

\item{G}{a Q x Q matrix of the prior covariance of A}

\item{prior_params}{a length 2 vector with the prior parameters for tau_v}

\item{BOLD}{a V x T matrix of BOLD values}

\item{Y_sq_sum}{a length V vector with the sum of squared BOLD values at
each data location}

\item{post_sums}{a list of posterior summary statistics including the named
summaries \code{AS_sq_sum}, \code{yAS_sum}, \code{A_sum}, and \code{AtA_sum}}

\item{sigma2_alpha}{a scalar multiplier for the prior variance of alpha}

\item{verbose}{a boolean. Should messages be generated and output?}
}
\value{
A list with quantities tau_sq, alpha, and G
}
\description{
Update parameters (M-step of the EM)
}
