% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcata.R
\encoding{UTF-8}
\name{get.mat.diff.sign}
\alias{get.mat.diff.sign}
\title{Pairwise comparisons}
\usage{
get.mat.diff.sign(x = x, y = y, n.x = n.x, n.y = n.x, test.type = "f")
}
\arguments{
\item{x}{citations for product x}

\item{y}{citations for product y}

\item{n.x}{total observations for x}

\item{n.y}{total observations for y}

\item{test.type}{So far only Fisher's exact test is implemented (\code{"f"})}
}
\description{
p-value for pairwise comparisons.
}
\examples{
# Toy TCATA citations data for two samples: s1, s2
s1 <- t(data.frame(sweet =  c(10, 23, 25, 26, 26, 43, 44),
                   bitter = c( 4, 18, 19, 27, 36, 43, 54),
                   sour = c(40, 53, 85, 70, 46, 33, 24)))
s2 <- t(data.frame(sweet = c(11, 33, 45, 46, 56, 43, 44),
                   bitter = c( 0, 11, 11, 14, 25, 35, 34),
                   sour = c(30, 33, 35, 20, 26, 23, 24)))
colnames(s1) <- colnames(s2) <- paste0("time_", seq(5, 35, by = 5), "s")
n <- 90
signif <- get.mat.diff.sign(s1, s2, n, n)
signif
}
\references{
Castura, J. C., Antúnez, L., Giménez, A., Ares, G. (2016). Temporal check-all-that-apply (TCATA): A novel temporal sensory method for characterizing products. \emph{Food Quality and Preference}, 47, 79-90. \url{http://dx.doi.org/10.1016/j.foodqual.2015.06.017}
}
\seealso{
\code{\link[stats]{fisher.test}}
}
