% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation.R
\name{compact-grid}
\alias{compact-grid}
\alias{compact_grid}
\alias{compact_grid2}
\title{Compact smoothed stress field}
\usage{
compact_grid(x, type = c("stress", "dispersion"))

compact_grid2(x, ..., FUN = min)
}
\arguments{
\item{x}{output of \code{\link[=stress2grid]{stress2grid()}}, \code{\link[=PoR_stress2grid]{PoR_stress2grid()}},
\code{\link[=stress2grid_stats]{stress2grid_stats()}}, or \code{\link[=kernel_dispersion]{kernel_dispersion()}}}

\item{type}{character. Type of the grid \code{x}. Either \code{"stress"} (when input
is \code{\link[=stress2grid]{stress2grid()}} or \code{\link[=PoR_stress2grid]{PoR_stress2grid()}}) or \code{"dispersion"} (when input
is \code{\link[=kernel_dispersion]{kernel_dispersion()}}).}

\item{...}{\verb{<tidy-select>} One unquoted expression separated by
commas. Variable names can be used as if they were positions in the data
frame. Variable must be a column in \code{x}.}

\item{FUN}{function is used to aggregate the data using the search radius
\code{R}. Default is \code{\link[=min]{min()}}.}
}
\value{
\code{sf} object
}
\description{
Filter smoothed stress field containing a range of search radii or kernel
half widths to find shortest wavelength (R) with the least circular sd. or
dispersion (or any statistic) for each coordinate, respectively.
}
\examples{
data("san_andreas")
res <- stress2grid(san_andreas)
compact_grid(res)

\dontrun{
res2 <- stress2grid_stats(san_andreas)
compact_grid2(res2, var, FUN = min)
}
}
\seealso{
\code{\link[=stress2grid]{stress2grid()}}, \code{\link[=PoR_stress2grid]{PoR_stress2grid()}}, \code{\link[=kernel_dispersion]{kernel_dispersion()}},
\code{\link[=stress2grid_stats]{stress2grid_stats()}}, \code{\link[dplyr:dplyr_tidy_select]{dplyr::dplyr_tidy_select()}}
}
