% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{circular_mode}
\alias{circular_mode}
\title{Circular Mode}
\usage{
circular_mode(x, kappa, axial = TRUE, n = 512)
}
\arguments{
\item{x}{numeric vector. Values in degrees.}

\item{kappa}{von Mises distribution concentration parameter}

\item{axial}{logical. Whether the data are axial, i.e. pi-periodical
(\code{TRUE}, the default) or directional, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).#' @param kappa}

\item{n}{the number of equally spaced points at which the density is to be estimated.}
}
\value{
numeric
}
\description{
Angle of maximum density of a specified von Mises distribution
}
\examples{
x <- rvm(10, 0, 100) \%\% 180
circular_mode(x, kappa = 2)
}
