% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_shmax.R
\name{PoR2Geo_azimuth}
\alias{PoR2Geo_azimuth}
\title{Azimuth conversion from PoR to geographical coordinate reference system}
\usage{
PoR2Geo_azimuth(x, PoR)
}
\arguments{
\item{x}{\code{data.frame} containing the PoR equivalent azimuths
(\code{azi.PoR}), and either the geographical coordinates of the
point(s) or the PoR-equivalent coordinates.}

\item{PoR}{\code{data.frame} containing the geographical location of
the Euler pole (\code{lat}, \code{lon})}
}
\value{
numeric vector of transformed azimuths (in degrees)
}
\description{
Conversion of PoR azimuths into geographical azimuths
}
\examples{
data("nuvel1")
# North America relative to Pacific plate:
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
data("san_andreas")
san_andreas$azi.PoR <- PoR_shmax(san_andreas, PoR)

# convert back to geo CRS
PoR2Geo_azimuth(san_andreas, PoR)
}
\references{
Stephan, T., Enkelmann, E., and Kroner, U. "Analyzing the
horizontal orientation of the crustal stress adjacent to plate boundaries".
\emph{Sci Rep} 13. 15590 (2023). \doi{10.1038/s41598-023-42433-2}.
}
\seealso{
\code{\link[=PoR_shmax]{PoR_shmax()}}
}
