% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_density}
\alias{plot_density}
\title{Circular density plot}
\usage{
plot_density(
  x,
  kappa,
  axial = TRUE,
  n = 512,
  norm_density = TRUE,
  ...,
  scale = 1.1,
  shrink = 1,
  add = TRUE,
  main = NULL,
  labels = TRUE,
  at = seq(0, 360 - 45, 45),
  cborder = TRUE
)
}
\arguments{
\item{x}{Data to be plotted. A numeric vector containing angles (in degrees).}

\item{kappa}{Concentration parameter for the von Mises distribution.
Small kappa gives smooth density lines.}

\item{axial}{Logical. Whether data are uniaxial (\code{axial=FALSE})
or biaxial (\code{TRUE}, the default).}

\item{n}{the number of equally spaced points at which the density is to be estimated.}

\item{norm_density}{logical. Normalize the density?}

\item{...}{Further graphical parameters may also be supplied as arguments.}

\item{scale}{radius of plotted circle. Default is \code{1.1}.}

\item{shrink}{parameter that controls the size of the plotted function. Default is 1.}

\item{add}{logical. Add to existing plot? (\code{TRUE} by default).}

\item{main}{Character string specifying the title of the plot.}

\item{labels}{Either a logical value indicating whether to plot labels
next to the tick marks, or a vector of labels for the tick marks.}

\item{at}{Optional vector of angles at which tick marks should be plotted.
Set \code{at=numeric(0)} to suppress tick marks.}

\item{cborder}{logical. Border of rose plot.}
}
\value{
plot or calculated densities as numeric vector
}
\description{
Plot the multiples of a von Mises density distribution
}
\examples{
rose(san_andreas$azi, dots = TRUE, stack = TRUE, dot_cex = 0.5, dot_pch = 21)
plot_density(san_andreas$azi, kappa = 10, col = "seagreen", shrink = 1.5)
plot_density(san_andreas$azi, kappa = 10, col = "seagreen", add = FALSE, scale = .6)
}
\seealso{
\code{\link[=dvm]{dvm()}}
}
