% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{circular_summary}
\alias{circular_summary}
\title{Circular Summary statistics}
\usage{
circular_summary(x, w = NULL, axial = TRUE, na.rm = FALSE)
}
\arguments{
\item{x}{numeric vector. Values in degrees.}

\item{w}{(optional) Weights. A vector of positive numbers and of the same
length as \code{x}.}

\item{axial}{logical. Whether the data are axial, i.e. pi-periodical
(\code{TRUE}, the default) or directional, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).}

\item{na.rm}{logical value indicating whether \code{NA} values in \code{x}
should be stripped before the computation proceeds.}
}
\value{
named vector
}
\description{
Circular mean, standard deviation, variance, quasi-quantiles, 95\% confidence
angle, standardized skewness and kurtosis
}
\examples{
data("nuvel1")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
sa.por <- PoR_shmax(san_andreas, PoR, "right")
circular_summary(sa.por$azi.PoR)
circular_summary(sa.por$azi.PoR, w = 1 / san_andreas$unc)
}
\seealso{
\code{\link[=circular_mean]{circular_mean()}}, \code{\link[=circular_sd]{circular_sd()}}, \code{\link[=circular_var]{circular_var()}},
\code{\link[=circular_quantiles]{circular_quantiles()}}, \code{\link[=confidence_angle]{confidence_angle()}}, \code{\link[=second_central_moment]{second_central_moment()}}
}
