% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve_delayed.R
\name{resolve_delayed}
\alias{resolve_delayed}
\alias{resolve_delayed.FilteredData}
\alias{resolve_delayed.list}
\title{Resolve delayed inputs by evaluating the code within the provided datasets}
\usage{
resolve_delayed(x, datasets, keys)

\method{resolve_delayed}{FilteredData}(
  x,
  datasets,
  keys = sapply(datasets$datanames(), datasets$get_keys, simplify = FALSE)
)

\method{resolve_delayed}{list}(x, datasets, keys = NULL)
}
\arguments{
\item{x}{(\code{delayed_data}, \code{list}) to resolve.}

\item{datasets}{(\code{FilteredData} or named \code{list}) to use as a reference to resolve \code{x}.}

\item{keys}{(named \code{list}) with primary keys for each dataset from \code{datasets}. \code{names(keys)}
should match \code{names(datasets)}.}
}
\value{
Resolved object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\section{Methods (by class)}{
\itemize{
\item \code{resolve_delayed(FilteredData)}: Default values for \code{keys} parameters is extracted from \code{datasets}.

\item \code{resolve_delayed(list)}: Generic method when \code{datasets} argument is a named list.

}}
\examples{
library(shiny)
ADSL <- teal.transform::rADSL
isolate({
  data_list <- list(ADSL = reactive(ADSL))

  # value_choices example
  v1 <- value_choices("ADSL", "SEX", "SEX")
  v1
  resolve_delayed(v1, data_list)

  # variable_choices example
  v2 <- variable_choices("ADSL", c("BMRKR1", "BMRKR2"))
  v2
  resolve_delayed(v2, data_list)

  # data_extract_spec example
  adsl_filter <- filter_spec(
    vars = variable_choices("ADSL", "SEX"),
    sep = "-",
    choices = value_choices("ADSL", "SEX", "SEX"),
    selected = "F",
    multiple = FALSE,
    label = "Choose endpoint and Censor"
  )

  adsl_select <- select_spec(
    label = "Select variable:",
    choices = variable_choices("ADSL", c("BMRKR1", "BMRKR2")),
    selected = "BMRKR1",
    multiple = FALSE,
    fixed = FALSE
  )

  adsl_de <- data_extract_spec(
    dataname = "ADSL",
    select = adsl_select,
    filter = adsl_filter
  )

  resolve_delayed(adsl_filter, datasets = data_list)
  resolve_delayed(adsl_select, datasets = data_list)
  resolve_delayed(adsl_de, datasets = data_list)

  # nested list (arm_ref_comp)
  arm_ref_comp <- list(
    ARMCD = list(
      ref = variable_choices("ADSL"),
      comp = variable_choices("ADSL")
    )
  )

  resolve_delayed(arm_ref_comp, datasets = data_list)
})
}
