% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilteredData-utils.R
\name{toggle_button}
\alias{toggle_button}
\alias{toggle_icon}
\alias{toggle_title}
\title{Toggle button properties.}
\usage{
toggle_icon(input_id, icons, one_way = FALSE)

toggle_title(input_id, titles, one_way = FALSE)
}
\arguments{
\item{input_id}{(\code{character(1)}) (name-spaced) id of the button}

\item{icons, titles}{(\code{character(2)}) vector specifying values between which to toggle}

\item{one_way}{(\code{logical(1)}) flag specifying whether to keep toggling;
if TRUE, the target will be changed
from the first element of \code{icons}/\code{titles} to the second}
}
\value{
\code{NULL}, invisibly.
}
\description{
Switch between different icons or titles on a button.
}
\details{
Wrapper functions that use \code{shinyjs::runjs} to change button properties in response to events,
typically clicking those very buttons.
\code{shiny}'s \code{actionButton} and \code{actionLink} create \verb{<a>} tags,
which may contain a child \verb{<i>} tag that specifies an icon to be displayed.
\code{toggle_icon} calls the \code{toggleClass} (when \code{one_way = FALSE}) or
\code{removeClass} and \code{addClass} methods (when \code{one_way = TRUE}) to change icons.
\code{toggle_title} calls the \code{attr} method to modify the \code{Title} attribute of the button.
}
\keyword{internal}
