% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_utils.R
\name{conv_str_logi}
\alias{conv_str_logi}
\title{Convert a character of a \code{yaml} boolean to a logical value}
\usage{
conv_str_logi(
  input,
  name = "",
  pos_logi = c("TRUE", "true", "True", "yes", "y", "Y", "on"),
  neg_logi = c("FALSE", "false", "False", "no", "n", "N", "off"),
  silent = TRUE
)
}
\arguments{
\item{input}{\code{character}}

\item{name}{\code{charcter}}

\item{pos_logi}{\code{character} vector of \code{yaml} values which should be treated as \code{TRUE}.}

\item{neg_logi}{\code{character} vector of \code{yaml} values which should be treated as \code{FALSE}.}

\item{silent}{\code{logical} if to suppress the messages and warnings.}
}
\value{
\code{input} argument or the appropriate \code{logical} value.
}
\description{
convert a character of a \code{yaml} boolean to a logical value.
}
\examples{

conv_str_logi <- getFromNamespace("conv_str_logi", "teal.reporter")
conv_str_logi("TRUE")
conv_str_logi("True")

conv_str_logi("off")
conv_str_logi("n")

conv_str_logi("sth")
}
\keyword{internal}
