% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teachingApp.R
\name{teachingApp}
\alias{teachingApp}
\title{Render a teachingApp With Options}
\usage{
teachingApp(
  app_name = NULL,
  theme = "flatly",
  width = "100\%",
  height = "800px",
  icon = "fa fa-github",
  img = NULL,
  git_user = "Auburngrads",
  more_opts = list(NA),
  launch.browser = TRUE,
  ...
)
}
\arguments{
\item{app_name}{\code{character} Name of the app to be rendered}

\item{theme}{\code{character} Name of a bootswatch color theme (provided by \code{shinythemes::shinytheme})}

\item{width}{\code{character} The width of the printed app (in pixels)}

\item{height}{\code{character} The height of the printed app (in pixels)}

\item{icon}{\code{character} A fontAwesome icon to be placed in the footer of a navbarPage app}

\item{img}{\code{character} A path (or URL) to an image to be placed in the footer of a navbarPage app}

\item{git_user}{\code{character} GitHub username used in the branding logo}

\item{more_opts}{A \code{list} of additional options/objects that can be passed to the app (see Details)}

\item{launch.browser}{\code{logical} If \code{TRUE} The app launches in the user's default browser}

\item{...}{A \code{list} of additional options passed to \code{shiny::shinyAppDir()}}
}
\value{
A printed shiny app
}
\description{
Renders a teachingApp as a stand-alone shiny app
    or as an element within an rmarkdown document.
}
\details{
The \code{teachingApps} package provides an infrastructure 
   that allows users to dynamically change the appearance and function of
   shiny apps. R users a familiar with writing functions to dynamically alter 
   some output - in this case the output is a app.  Normally,
}
\examples{
\dontrun{
teachingApps(app_name = 'distribution_weibull', 
             theme = 'spacelab', 
             height = '800px')

teachingApps(app_name = 'maximum_likelihood_simulation',
             theme = 'flatly',
             height = '600px')
}
}
\seealso{
code{link{create_logo}}

code{link{add_logo}}
}
