% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chesmore2011-data.R
\docType{data}
\name{chesmore2011}
\alias{chesmore2011}
\title{Coding Matrix from Chesmore (2011)}
\format{Matrix}
\source{
\href{https://phenome.jax.org/projects/Moore1b}{QTL Archive}
}
\usage{
data(chesmore2011)
}
\description{
Coding matrix used for Orthoptera.
}
\examples{
library(tuneR)
wave <- readWave(system.file("extdata", "1.wav", package="tdsc"))
data(chesmore2011)
t <- tdsc(wave, coding_matrix=chesmore2011)
}
\references{
Chesmore, E David (2001). “Application of time domain signal coding and archecktificial neural networks to passive acoustical identification of animals”. In: Applied Acoustics 62.12, pp. 1359–1374.
}
\keyword{CodingMatrix}
\keyword{TDSC}
