% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.multi.yearly}
\alias{f.multi.yearly}
\title{Creates a Multi-Year Frequency}
\usage{
f.multi.yearly(year, z)
}
\arguments{
\item{year}{Year of the observation.}

\item{z}{Number of years. It should be larger than zero.}
}
\value{
An object of class 'ldtf'. It is also a list with the following members:
\tabular{ll}{
\code{class} \tab Determines the class of this frequency.\cr
\code{year} \tab Determines the \code{year}.\cr
\code{z} \tab Determines the value: \code{z}.
}
}
\description{
Use it to create a frequency for time-series data that occurs every \code{z} years.
}
\details{
In order to use \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format} \code{"#"} (the number is the \code{year}, which means the string representation is the first year of the interval)
\item \strong{Class Id} \code{"z#"} ('#' represents the value: \code{z}; e.g., z3 means every 3 years)
}
}
\examples{

my0 <- f.multi.yearly(2020, 2)
#      this is a multi-year frequency that refers to the year 2020.
#      The next observation is expected in 2022 (not the next year).

my0_value_str <-  as.character(my0) # this will be '2020'.
my0_class_str <- get.class.id(my0) # this will be 'z2'.

my_new <- as.frequency("2020", "z3")
#      this is a multi-year frequency that refers to the year 2020.
#      However, the next observation is expected in 2023.

# Don't make the following mistakes:
\donttest{
my_invalid <- try(f.multi.yearly(2020, 0))
my_invalid <- try(f.multi.yearly(2020, -5))
my_invalid <- try(as.frequency("2021", "z"))
}

}
