% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.multi.weekly}
\alias{f.multi.weekly}
\title{Creates a Multi-Week Frequency}
\usage{
f.multi.weekly(year, month, day, k)
}
\arguments{
\item{year}{Year of the observation. It should be a valid year as an integer.}

\item{month}{Month of the observation. It should be a valid month of year as an integer.}

\item{day}{Day of the observation which will determine the start of the week. It should be a valid day of month as an integer.}

\item{k}{Number of weeks.}
}
\value{
An object of class 'ldtf'. It is also a list with the following members:
\tabular{ll}{
\code{class} \tab Determines the class of this frequency.\cr
\code{year} \tab Determines the \code{year}.\cr
\code{month} \tab Determines the \code{month}.\cr
\code{day} \tab Determines the \code{day}.\cr
\code{k} \tab Determines the value: \code{k}.
}
}
\description{
Use it to create a frequency for time-series data that occurs every 'k' weeks. We use first day of the first week as the reference.
}
\details{
In order to use \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format} First day of the first week in \code{"YYYYMMDD"} format.
\item \strong{Class Id} \code{"w#"} (the number is value: \code{k}; e.g., w3 means every 3 weeks)
}
}
\examples{

mw0 <- f.multi.weekly(2023, 1, 2,3)
#      This is 2/1/2023 which is Monday. Next observation belongs to 23/1/2023.

mw0_value_str <-  as.character(mw0) # this will be '20230102'.
mw0_class_str <- get.class.id(mw0) # this will be 'w3'.

mw_new <- as.frequency("20230109", "w4") # This is 9/1/2023.

# Don't use invalid or unsupported dates:
\donttest{
mw_invalid <- try(as.frequency("1399109", "w4")) # this is a too old date and unsupported
mw_invalid <- try(as.frequency("20230132", "w5")) # invalid day in month
mw_invalid <- try(as.frequency("20231331", "w2")) # invalid month
mw_invalid <- try(as.frequency("20231012", "w0"))
}

}
