% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-blur.R
\name{step_blur}
\alias{step_blur}
\alias{tidy.step_blur}
\title{Blur raster data}
\usage{
step_blur(
  recipe,
  ...,
  role = NA_character_,
  trained = FALSE,
  xmin = 0,
  xmax = 1,
  blur_sigmas = NULL,
  skip = FALSE,
  id = rand_id("blur")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose variables for this step.
See \code{\link[recipes:selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from the
original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for preprocessing have
been estimated.}

\item{xmin, xmax, blur_sigmas}{Parameters passed to \code{\link[=blur]{blur()}}.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked by
\code{\link[recipes:bake]{bake()}}? While all operations are baked when \code{\link[recipes:prep]{prep()}} is run, some
operations may not be able to be conducted on new data (e.g. processing the
outcome variable(s)). Care should be taken when using \code{skip = TRUE} as it
may affect the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
The function \code{step_blur()} creates a \emph{specification} of a recipe
step that will induce Gaussian blur in numerical arrays. The input and
output must be list-columns.
}
\details{
The gaussian blur step deploys \code{\link[=blur]{blur()}}. See there for definitions
and references.

\strong{TODO:} Explain the importance of blur for PH of image data.
}
\section{Tuning Parameters}{


This step has 1 tuning parameter(s):
\itemize{
\item \code{blur_sigmas}: Gaussian Blur std. dev.s (type: double, default: NULL)
}
}

\examples{
topos <- data.frame(pix = I(list(volcano)))

blur_rec <- recipe(~ ., data = topos) \%>\% step_blur(pix)
blur_prep <- prep(blur_rec, training = topos)
blur_res <- bake(blur_prep, topos)

tidy(blur_rec, number = 1)
tidy(blur_prep, number = 1)

with_sigmas <- recipe(~ ., data = topos) \%>\% step_blur(pix, blur_sigmas = 10)
with_sigmas <- bake(prep(with_sigmas, training = topos), topos)

ops <- par(mfrow = c(1, 3))
image(topos$pix[[1]])
image(blur_res$pix[[1]])
image(with_sigmas$pix[[1]])
par(ops)
}
