% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitexp2.R
\name{fitexp2}
\alias{fitexp2}
\title{Exponential 2 Model Fit}
\usage{
fitexp2(conc, resp, bidirectional = TRUE, verbose = FALSE, nofit = FALSE)
}
\arguments{
\item{conc}{Vector of concentration values NOT in log units.}

\item{resp}{Vector of corresponding responses.}

\item{bidirectional}{If TRUE, model can be positive or negative; if FALSE, it
will be positive only.}

\item{verbose}{If TRUE, gives optimization and hessian inversion details.}

\item{nofit}{If nofit = TRUE, returns formatted output filled with missing values.}
}
\value{
Named list containing: success, aic (Akaike Information Criteria),
  cov (success of covariance calculation), rme (root mean square error),
  modl (vector of model values at given concentrations),
  parameters values, parameter sd (standard deviation) estimates, pars
  (vector of parameter names), sds (vector of parameter sd names).
}
\description{
Function that fits to \eqn{f(x) = a*(e^{(x/b)}- 1)} and returns generic model outputs.
}
\details{
Zero background and increasing absolute response are assumed. Parameters are
"a" (y scale), "b" (x scale), and error term "er".
success = 1 for a successful fit, 0 if optimization failed, and NA if
nofit = TRUE. cov = 1 for a successful hessian inversion, 0 if it fails, and NA
if nofit = TRUE. aic, rme, modl, parameters, and parameter sds are set to
NA in case of nofit or failure.
}
\examples{
fitexp2(c(.1,1,10,100), c(0,.1,1,10))
}
