% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_mods.R
\name{pk_solution_3cpt_metab}
\alias{pk_solution_3cpt_metab}
\title{Iterate solution to three-compartment model}
\usage{
pk_solution_3cpt_metab(pars, ivt, init)
}
\arguments{
\item{pars}{Named vector of parameters for a 3-compartment model with effect-site.}

\item{ivt}{Infusion schedule given in the form of a named list
(e.g. list(list(begin = 0, end = 2, k_R = 1), list(begin = 4, end = 6, k_R = 1)))}

\item{init}{inital concentrations for the 4 compartments.}
}
\value{
Numeric matrix of concentrations for a set of infusions
}
\description{
This function extends the function pk_basic_solution_3cpt_metab to a specified infusion schedule, rather than a single
infusion.
}
\examples{
data(eleveld_pk)
pk_pars <- subset(eleveld_pk, ID == 403, c("V1","V2","V3","CL","Q2","Q3"))
pd_pars <- subset(eleveld_pd, ID == 403, c("E50","KE0","EMAX","GAM","GAM1","RESD"))
pars <- c(k10 = pk_pars$CL / pk_pars$V1,
          k12 = pk_pars$Q2 / pk_pars$V1,
          k21 = pk_pars$Q2 / pk_pars$V2,
          k13 = pk_pars$Q3 / pk_pars$V1,
          k31 = pk_pars$Q3 / pk_pars$V3,
          v1 = pk_pars$V1,
          v2 = pk_pars$V2,
          v3 = pk_pars$V3,
          ke0 = pd_pars$KE0)
ivt <- list(list(begin=0.0, end=0.5, k_R=6),
            list(begin=8.0, end=8.5, k_R=6),
            list(begin=16.0, end=16.5, k_R=6),
            list(begin=24.0, end=24.5, k_R=6),
            list(begin=32.0, end=32.5, k_R=6))
init <- c(0,0,0,0)
sol <- pk_solution_3cpt_metab(pars, ivt, init)
sol(seq(0,32))
}
