% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_mods.R
\name{gen_eleveld_pk_pars}
\alias{gen_eleveld_pk_pars}
\title{Eleveld model PK parameters}
\usage{
gen_eleveld_pk_pars(theta, eta, patient_vars, returnQ = FALSE)
}
\arguments{
\item{theta}{Vector of fixed effects}

\item{eta}{Vector of random effects}

\item{patient_vars}{Named list of observed patient characteristics}

\item{returnQ}{Logical. Should clearance be returned instead of rates}
}
\value{
Numeric vector of PK parameters for Eleveld propofol model associated
with a set of patient covariates.
}
\description{
Function to generate PK parameters for Eleveld model.
}
\examples{
data(eleveld_pk)
# PK fixed effect values and random effect variances from Eleveld et al. (2018)
eleveld_theta_pk_est <- c(6.28,25.5,273,1.79,1.75,1.11,0.191,42.3,9.06,-0.0156,
-0.00286,33.6,-0.0138,68.3,2.10,1.30,1.42,0.68)
eleveld_eta_pk_var <- c(0.610,0.565,0.597,0.265,0.346,0.209,0.463)

# Example patient covariate values, fixed effects, and random effects
vars <- c("AGE","WGT","HGT","M1F2","PMA","TECH","BMI","FFM","A1V2")
patient_covariates <- subset(eleveld_pk, ID == 403, select = vars)
eta_obs <- c(mvtnorm::rmvnorm(1,sigma = diag(eleveld_eta_pk_var)))
gen_eleveld_pk_pars(theta = eleveld_theta_pk_est,
                    eta = eta_obs,
                    patient_vars = patient_covariates)
}
