% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tci_algorithms.R
\name{tci_comb}
\alias{tci_comb}
\title{Effect-site TCI algorithm with plasma targeting within small range of target}
\usage{
tci_comb(Ct, pkmod, cptol = 0.2, cetol = 0.05, cp_cmpt = 1, ce_cmpt = 4, ...)
}
\arguments{
\item{Ct}{Numeric vector of target effect-site concentrations.}

\item{pkmod}{PK model}

\item{cptol}{Percentage of plasma concentration required to be within to switch
to plasma targeting.}

\item{cetol}{Percentage of effect-site concentration required to be within to switch
to plasma targeting.}

\item{cp_cmpt}{Position of central compartment. Defaults to first compartment.}

\item{ce_cmpt}{Position of effect-site compartment. Defaults to fourth compartment.}

\item{...}{Arguments passed on to 'tci_plasma' and 'tci_effect' functions.}
}
\description{
Modified effect-site TCI algorithm that switches to plasma-targeting when the
plasma concentration is within 20\%
of the target and the effect-site concentration is within 0.5\% of the target.
The modification decreases computation time and prevents oscillatory behavior
in the effect-site concentrations.
}
