% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xts_tbl.R
\name{xts_tbl}
\alias{xts_tbl}
\title{xts_tbl}
\usage{
xts_tbl(xts)
}
\arguments{
\item{xts}{A xts series that will be converted to a tbl_df().}
}
\value{
A tbl_df() with the first column the "date"  column used to order the xts series by.
}
\description{
This function converts data from a xts object to a tbl_df().
Note that the dataframe must be of type xts and ordered by a date column. This date column will be preserved and save as "date".
}
\examples{
\dontrun{
library(dplyr)
data(TRI)
df_xts_tbl <- TRI \%>\% tbl_xts(., cols_to_xts = "TRI", spread_by = "Country") \%>\% xts_tbl()
}
}
