% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{getCommon}
\alias{getCommon}
\title{Find common names for a given taxa}
\usage{
getCommon(taxa, sqlFile = "nameNode.sqlite", types = NULL)
}
\arguments{
\item{taxa}{a vector of accession numbers}

\item{sqlFile}{a string giving the path to a SQLite file containing a names tables}

\item{types}{a vector of strings giving the type of names desired e.g. "common name". If NULL then all types are returned}
}
\value{
a named list of data.frames where each element corresponds to the query taxa IDs. Each data.frame contains columns name and type and each gives an available names and its name type
}
\description{
Find all common names recorded for a taxa in the NCBI taxonomy. Use \code{\link{getTaxonomy}} for scientific names.
}
\examples{
namesText<-"9894\t|\tGiraffa camelopardalis (Linnaeus, 1758)\t|\t\t|\tauthority\t|
9894\t|\tGiraffa camelopardalis\t|\t\t|\tscientific name\t|
9894\t|\tgiraffe\t|\t\t|\tgenbank common name\t|
9909\t|\taurochs\t|\t\t|\tgenbank common name\t|
9909\t|\tBos primigenius Bojanus, 1827\t|\t\t|\tauthority\t|
9909\t|\tBos primigenius\t|\t\t|\tscientific name\t|
9913\t|\tBos bovis\t|\t\t|\tsynonym\t|
9913\t|\tBos primigenius taurus\t|\t\t|\tsynonym\t|
9913\t|\tBos taurus Linnaeus, 1758\t|\t\t|\tauthority\t|
9913\t|\tBos taurus\t|\t\t|\tscientific name\t|
9913\t|\tBovidae sp. Adi Nefas\t|\t\t|\tincludes\t|
9913\t|\tbovine\t|\t\t|\tcommon name\t|
9913\t|\tcattle\t|\t\t|\tgenbank common name\t|
9913\t|\tcow\t|\t\t|\tcommon name\t|
9913\t|\tdairy cow\t|\t\t|\tcommon name\t|
9913\t|\tdomestic cattle\t|\t\t|\tcommon name\t|
9913\t|\tdomestic cow\t|\t\t|\tcommon name\t|
9913\t|\tox\t|\t\t|\tcommon name\t|
9913\t|\toxen\t|\t\t|\tcommon name\t|
9916\t|\tBoselaphus\t|\t\t|\tscientific name\t|"
tmpFile<-tempfile()
writeLines(namesText,tmpFile)
sqlFile<-tempfile()
read.names.sql(tmpFile,sqlFile)
getCommon(9909,sqlFile)
sapply(getCommon(c(9894,9913),sqlFile),function(xx)paste(xx$name,collapse='; '))
getCommon(c(9999999,9916,9894,9913),sqlFile,c("common name","genbank common name"))
}
\seealso{
\code{\link{getTaxonomy}}, \code{\link{read.names.sql}}, \code{\link{getId}}
}
