% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bold_downstream.R
\name{bold_downstream}
\alias{bold_downstream}
\title{Retrieve all taxa names downstream in hierarchy for BOLD}
\usage{
bold_downstream(id, downto, intermediate = FALSE, ...)
}
\arguments{
\item{id}{(integer) One or more BOLD taxonomic identifiers}

\item{downto}{(character) The taxonomic level you want to go down to.
See examples below. The taxonomic level IS case sensitive, and you do have
to spell it correctly. See \code{data(rank_ref)} for spelling.}

\item{intermediate}{(logical) If \code{TRUE}, return a list of length two
with target taxon rank names, with additional list of data.frame's of
intermediate taxonomic groups. Default: \code{FALSE}}

\item{...}{crul options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\value{
data.frame of taxonomic information downstream to family from e.g.,
Order, Class, etc., or if \code{intermediated=TRUE}, list of length two,
with target taxon rank names, and intermediate names.
}
\description{
Retrieve all taxa names downstream in hierarchy for BOLD
}
\details{
BEWARE: This function scrapes the BOLD website, so may be unstable. That is,
one day it may work, and the next it may fail. Open an issue if you
encounter an error: https://github.com/ropensci/taxize/issues
}
\examples{
\dontrun{
## the genus Gadus
bold_downstream(id = 3451, downto="species")

bold_downstream(id = 443, downto="genus")
bold_downstream(id = 443, downto="genus", intermediate=TRUE)
}
}
