% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbif_downstream.R
\name{gbif_downstream}
\alias{gbif_downstream}
\title{Retrieve all taxa names downstream in hierarchy for GBIF}
\usage{
gbif_downstream(key, downto, intermediate = FALSE, ...)
}
\arguments{
\item{key}{A taxonomic serial number.}

\item{downto}{The taxonomic level you want to go down to. See examples below.
The taxonomic level IS case sensitive, and you do have to spell it
correctly. See \code{data(rank_ref)} for spelling.}

\item{intermediate}{(logical) If TRUE, return a list of length two with target
taxon rank names, with additional list of data.frame's of intermediate
taxonomic groups. Default: FALSE}

\item{...}{Further args passed on to \code{\link{gbif_name_usage}}}
}
\value{
Data.frame of taxonomic information downstream to family from e.g.,
		Order, Class, etc., or if \code{intermediated=TRUE}, list of length two,
  	with target taxon rank names, and intermediate names.
}
\description{
Retrieve all taxa names downstream in hierarchy for GBIF
}
\examples{
\dontrun{
## the plant class Bangiophyceae
gbif_downstream(key = 198, downto="Genus")
gbif_downstream(key = 198, downto="Genus", intermediate=TRUE)

# get families downstream from the superfamily Acridoidea
gbif_downstream(key = 110610447, "Family")
## here, intermediate leads to the same result as the target
gbif_downstream(key = 110610447, "Family", intermediate=TRUE)

# get species downstream from the genus Ursus
gbif_downstream(key = 2433406, "Species")

# get tribes down from the family Apidae
gbif_downstream(key = 1334757, downto="Species")
gbif_downstream(key = 1334757, downto="Species", intermediate=TRUE)
}
}
\author{
Scott Chamberlain \email{myrmecocystus@gmail.com}
}

