% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/upstream.R
\name{upstream}
\alias{upstream}
\alias{upstream.colid}
\alias{upstream.default}
\alias{upstream.ids}
\alias{upstream.tsn}
\title{Retrieve the upstream taxa for a given taxon name or ID.}
\usage{
upstream(...)

\method{upstream}{default}(x, db = NULL, upto = NULL, rows = NA, ...)

\method{upstream}{tsn}(x, db = NULL, upto = NULL, ...)

\method{upstream}{colid}(x, db = NULL, upto = NULL, ...)

\method{upstream}{ids}(x, db = NULL, upto = NULL, ...)
}
\arguments{
\item{...}{Further args passed on to \code{itis_downstream} or \code{col_downstream}}

\item{x}{character; taxons to query.}

\item{db}{character; database to query. One or both of \code{itis}, \code{col}.}

\item{upto}{What taxonomic rank to go down to. One of: 'Superkingdom','Kingdom',
'Subkingdom','Infrakingdom','Phylum','Division','Subphylum','Subdivision','Infradivision',
'Superclass','Class','Subclass','Infraclass','Superorder','Order','Suborder',
'Infraorder','Superfamily','Family','Subfamily','Tribe','Subtribe','Genus','Subgenus',
'Section','Subsection','Species','Subspecies','Variety','Form','Subvariety','Race',
'Stirp','Morph','Aberration','Subform','Unspecified'}

\item{rows}{(numeric) Any number from 1 to inifity. If the default NA, all rows are
considered. Note that this parameter is ignored if you pass in a taxonomic id of any of the
acceptable classes: tsn, colid.}
}
\value{
A named list of data.frames with the upstream names of every supplied taxa.
You get an NA if there was no match in the database.
}
\description{
This function uses a while loop to continually collect taxa up to the
taxonomic rank that you specify in the \code{upto} parameter. You can get data
from ITIS (itis) or Catalogue of Life (col). There is no method exposed by itis
or col for getting taxa at a specific taxonomic rank, so we do it ourselves inside
the function.
}
\examples{
\dontrun{
## col
upstream("Pinus contorta", db = 'col', upto = 'Genus') # get all genera at one level up
upstream("Abies", db = 'col', upto = 'Genus') # goes to same level, Abies is a genus
upstream('Pinus contorta', db = 'col', upto = 'Family')
upstream('Poa annua', db = 'col', upto = 'Family')
upstream('Poa annua', db = 'col', upto = 'Order')

## itis
upstream(x='Pinus contorta', db = 'itis', upto = 'Genus')

## both
upstream(get_ids('Pinus contorta', db = c('col','itis')), upto = 'Genus')

# Use rows parameter to select certain
upstream('Poa annua', db = 'col', upto = 'Genus')
upstream('Poa annua', db = 'col', upto = 'Genus', rows=1)

# use curl options
res <- upstream('Poa annua', db = 'col', upto = 'Genus', config=verbose())
}
}

