% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_filter.R
\name{fuzzy_filter}
\alias{fuzzy_filter}
\title{Match names that start or contain a specified text string}
\usage{
fuzzy_filter(
  name,
  by = c("scientificName", "vernacularName"),
  provider = getOption("taxadb_default_provider", "itis"),
  match = c("contains", "starts_with"),
  version = latest_version(),
  db = td_connect(),
  ignore_case = TRUE,
  collect = TRUE
)
}
\arguments{
\item{name}{vector of names (scientific or common, see \code{by})
to be matched against.}

\item{by}{a column name in the taxa_tbl (following Darwin Core Schema terms).
The filtering join is executed with this column as the joining variable.}

\item{provider}{from which provider should the hierarchy be returned?
Default is 'itis', which can also be configured using \verb{options(default_taxadb_provider=...")}.
See \verb{[td_create]} for a list of recognized providers.}

\item{match}{should we match by names starting with the term or containing
the term anywhere in the name?}

\item{version}{Which version of the taxadb provider database should we use?
defaults to latest.  See \link{tl_import} for details.}

\item{db}{a connection to the taxadb database. See details.}

\item{ignore_case}{should we ignore case (capitalization) in matching names?
default is \code{TRUE}.}

\item{collect}{logical, default \code{TRUE}. Should we return an in-memory
data.frame (default, usually the most convenient), or a reference to
lazy-eval table on disk (useful for very large tables on which we may
first perform subsequent filtering operations.)}
}
\description{
Match names that start or contain a specified text string
}
\details{
Note that fuzzy filter will be fast with an single or small number
of names, but will be slower if given a very large vector of
names to match, as unlike other \code{filter_} commands,
fuzzy matching requires separate SQL calls for each name.
As fuzzy matches should all be confirmed manually in any event, e.g.
not every common name containing "monkey" belongs to a primate species.

This method utilizes the database operation \verb{\%like\%} to filter tables without
loading into memory.  Note that this does not support the use of regular
expressions at this time.
}
\examples{
\donttest{
  \dontshow{
   ## All examples use a temporary directory
   Sys.setenv(TAXADB_HOME=file.path(tempdir(), "taxadb"))
   options("taxadb_default_provider"="itis_test")
  }

## match any common name containing:
name <- c("woodpecker", "monkey")
fuzzy_filter(name, "vernacularName")

## match scientific name
fuzzy_filter("Chera", "scientificName",
             match = "starts_with")
}

}
