% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_name.R
\name{filter_name}
\alias{filter_name}
\title{Look up taxonomic information by scientific name}
\usage{
filter_name(
  name,
  provider = getOption("taxadb_default_provider", "itis"),
  version = latest_version(),
  collect = TRUE,
  ignore_case = TRUE,
  db = td_connect()
)
}
\arguments{
\item{name}{a character vector of scientific names, e.g. "Homo sapiens"}

\item{provider}{from which provider should the hierarchy be returned?
Default is 'itis', which can also be configured using \verb{options(default_taxadb_provider=...")}.
See \verb{[td_create]} for a list of recognized providers.}

\item{version}{Which version of the taxadb provider database should we use?
defaults to latest.  See \link{available_versions} for details.}

\item{collect}{logical, default \code{TRUE}. Should we return an in-memory
data.frame (default, usually the most convenient), or a reference to
lazy-eval table on disk (useful for very large tables on which we may
first perform subsequent filtering operations.)}

\item{ignore_case}{should we ignore case (capitalization) in matching names?
default is \code{TRUE}.}

\item{db}{a connection to the taxadb database. See details.}
}
\value{
a data.frame in the Darwin Core tabular format containing the
matching taxonomic entities.
}
\description{
Look up taxonomic information by scientific name
}
\details{
Most but not all authorities can match against both species level and
higher-level (or lower, e.g. subspecies or variety) taxonomic names.
The rank level is indicated by \code{taxonRank} column.

Most authorities include both known synonyms and accepted names in the
\code{scientificName} column, (with the status indicated by \code{taxonomicStatus}).
This is convenient, as users will typically not know if the names they
have are synonyms or accepted names, but will want to get the match to the
accepted name and accepted ID in either case.
}
\examples{
\donttest{
  \dontshow{
   ## All examples use a temporary directory
   Sys.setenv(TAXADB_HOME=tempdir())
  }

sp <- c("Trochalopteron henrici gucenense",
        "Trochalopteron elliotii")
filter_name(sp)

}

}
\seealso{
Other filter_by: 
\code{\link{filter_by}()},
\code{\link{filter_common}()},
\code{\link{filter_id}()},
\code{\link{filter_rank}()}
}
\concept{filter_by}
