% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R,
%   R/getter_setter_s3_generics.R, R/taxon.R, R/taxon_id.R, R/taxonomy.R
\name{tax_db.taxa_classification}
\alias{tax_db.taxa_classification}
\alias{tax_db<-.taxa_classification}
\alias{tax_db}
\alias{tax_db<-}
\alias{tax_db.taxa_taxon}
\alias{tax_db<-.taxa_taxon}
\alias{tax_db.taxa_taxon_id}
\alias{tax_db<-.taxa_taxon_id}
\alias{tax_db.taxa_taxonomy}
\alias{tax_db<-.taxa_taxonomy}
\title{Set and get taxon ID databases}
\usage{
\method{tax_db}{taxa_classification}(x)

\method{tax_db}{taxa_classification}(x) <- value

tax_db(x)

tax_db(x) <- value

\method{tax_db}{taxa_taxon}(x)

\method{tax_db}{taxa_taxon}(x) <- value

\method{tax_db}{taxa_taxon_id}(x)

\method{tax_db}{taxa_taxon_id}(x) <- value

\method{tax_db}{taxa_taxonomy}(x)

\method{tax_db}{taxa_taxonomy}(x) <- value
}
\arguments{
\item{x}{An object with taxon authority dates.}

\item{value}{The taxon citations to set. Inputs will be coerced into a \link{taxon_db} vector.}
}
\description{
Set and get the taxon ID databases in objects that have them, such as \link{taxon_id} objects.
}
\examples{
x <- taxon_id(c('9606', '1386', '4890', '4345'), db = 'ncbi')
tax_db(x)
tax_db(x) <- 'nbn'
tax_db(x)[2] <- 'itis'

}
