% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{n_leaves_1}
\alias{n_leaves_1}
\title{Get number of leaves}
\arguments{
\item{obj}{(\code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}})}
}
\value{
\code{numeric}
}
\description{
Get number of leaves for each taxon in an object of type
\code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}}, not including leaves of subtaxa etc.
\preformatted{
obj$n_leaves_1()
n_leaves_1(obj)}
}
\examples{
# Get number of leaves for each taxon
n_leaves_1(ex_taxmap)

# Filter taxa based on number of leaves
filter_taxa(ex_taxmap, n_leaves_1 > 0)

}
\seealso{
Other taxonomy data functions: 
\code{\link{classifications}()},
\code{\link{id_classifications}()},
\code{\link{is_branch}()},
\code{\link{is_internode}()},
\code{\link{is_leaf}()},
\code{\link{is_root}()},
\code{\link{is_stem}()},
\code{\link{map_data_}()},
\code{\link{map_data}()},
\code{\link{n_leaves}()},
\code{\link{n_subtaxa_1}()},
\code{\link{n_subtaxa}()},
\code{\link{n_supertaxa_1}()},
\code{\link{n_supertaxa}()},
\code{\link{taxon_ids}()},
\code{\link{taxon_indexes}()},
\code{\link{taxon_names}()},
\code{\link{taxon_ranks}()}
}
\concept{taxonomy data functions}
