% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{taxonomy_table}
\alias{taxonomy_table}
\title{Convert taxonomy info to a table}
\arguments{
\item{obj}{A \code{taxonomy} or \code{taxmap} object}

\item{subset}{Taxon IDs, TRUE/FALSE vector, or taxon indexes to find
supertaxa for. Default: All leaves will be used. Any variable name that
appears in \code{\link[=all_names]{all_names()}} can be used as if it was a vector on its own.}

\item{value}{What data to return. Default is taxon names. Any result of
\code{\link[=all_names]{all_names()}} can be used, but it usually only makes sense to use data with
one value per taxon, like taxon names.}

\item{use_ranks}{Which ranks to use. Must be one of the following:
\itemize{
\item \code{NULL} (the default): If there is rank information, use the ranks that
appear in the lineage with the most ranks. Otherwise, assume the number of
supertaxa corresponds to rank and use placeholders for the rank column names
in the output.
\item \code{TRUE}: Use the ranks that appear in the lineage with the most ranks. An
error will occur if no rank information is available.
\item \code{FALSE}: Assume the number of supertaxa corresponds to rank and use
placeholders for the rank column names in the output. Do not use included
rank information.
\item \code{character}: The names of the ranks to use. Requires included rank information.
\item \code{numeric}: The "depth" of the ranks to use. These are equal to \code{n_supertaxa} + 1.
}}

\item{add_id_col}{If \code{TRUE}, include a taxon ID column.}
}
\value{
A tibble of taxa (rows) by ranks (columns).
}
\description{
Convert per-taxon information, like taxon names, to a table of taxa (rows) by
ranks (columns).
}
\examples{
# Make a table of taxon names
taxonomy_table(ex_taxmap)

# Use a differnt value
taxonomy_table(ex_taxmap, value = "taxon_ids")

# Return a subset of taxa
taxonomy_table(ex_taxmap, subset = taxon_ranks == "genus")

# Use arbitrary ranks names based on depth
taxonomy_table(ex_taxmap, use_ranks = FALSE)

}
