% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_cancel.R
\name{tar_cancel}
\alias{tar_cancel}
\title{Cancel a target mid-execution under a custom condition.}
\usage{
tar_cancel(condition = TRUE)
}
\arguments{
\item{condition}{Logical of length 1, whether to cancel the target.}
}
\description{
Cancel a target while its command is running
if a condition is met.
}
\details{
Must be invoked by the target itself. \code{tar_cancel()}
cannot interrupt a target from another process.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script(tar_target(x, tar_cancel(1 > 0)))
tar_make() # Should cancel target x.
})
}
}
\seealso{
Other utilities: 
\code{\link{tar_active}()},
\code{\link{tar_backoff}()},
\code{\link{tar_call}()},
\code{\link{tar_definition}()},
\code{\link{tar_described_as}()},
\code{\link{tar_envir}()},
\code{\link{tar_format_get}()},
\code{\link{tar_group}()},
\code{\link{tar_name}()},
\code{\link{tar_path}()},
\code{\link{tar_path_script}()},
\code{\link{tar_path_script_support}()},
\code{\link{tar_path_store}()},
\code{\link{tar_path_target}()},
\code{\link{tar_source}()},
\code{\link{tar_store}()}
}
\concept{utilities}
